import sys
input = sys.stdin.readline

n = int(input())
x = list(map(int, input().split()))
h = list(map(int, input().split()))

order = sorted(range(n), key=lambda i: x[i])
x = [x[i] for i in order]
h = [h[i] for i in order]

def rope_height(xa, ha, xb, hb, xp):
    xm = (xa + ha + xb - hb) // 2
    if xp <= xm:
        return ha - (xp - xa)
    else:
        return hb - (xb - xp)

INF = float("inf")
ans = [INF] * n

for i in range(n):
    xi, hi = x[i], h[i]

    for j in range(n):
        if h[j] >= hi:
            ans[i] = min(ans[i], abs(x[j] - xi))

    if i > 0:
        xa, ha = x[i-1], h[i-1]
        xb, hb = x[i], h[i]
        for xp in range(xa, xb+1):
            if rope_height(xa, ha, xb, hb, xp) >= hi:
                ans[i] = min(ans[i], abs(xp - xi))

    if i < n-1:
        xa, ha = x[i], h[i]
        xb, hb = x[i+1], h[i+1]
        for xp in range(xa, xb+1):
            if rope_height(xa, ha, xb, hb, xp) >= hi:
                ans[i] = min(ans[i], abs(xp - xi))

for idx, pos in enumerate(order):
    if ans[idx] == INF:
        print(-1)
    else:
        print(ans[idx])